	%	 Ex 12.11
	close all, clear all, clc
	N = 12; M = 0; Nband= 3;
	Be =[0 0.2 0.25 0.4 0.45 1]*pi; 	% Band edges
	PhaseDiff = [0 -1 -2]*pi;			% Phase differences
	W = [10 10 1]; 
	[Z1, P1, Z2, P2, Att] = SYM_WDF(N, M,Nband,Be,PhaseDiff,W);
	wT = linspace(0, pi, 1000);
	Sden1 = poly(P1);	  Sden2 = poly(P2);	 
	S1 = freqz(fliplr(Sden1), Sden1,wT); % Select according to Figure 12.6
	S2 = -freqz(fliplr(Sden2), Sden2,wT);
	H  = 0.5*(S2-S1);
	figure(1); subplot(2,1,1)
	PLOT_MAG_Z_dB(wT, H, pi, 60, 'H'), zoom on
	figure(2); subplot(2,1,1)
	PLOT_PZ_Z(Z1,P1)
	figure(3), subplot(2,1,1)
	PLOT_PZ_Z(Z2,P2)		
	figure(4);subplot(2,1,1), Npi = -9; % y-axis
	PLOT_PHASE_Z2(wT,unwrap(angle(-S1)), Npi), hold on
	PLOT_PHASE_Z2(wT,unwrap(angle(S2)), Npi)
	fprintf('\n')
	for n = 1:Nband
		fprintf('%1.0f. band  %2.12f dB \n',n,Att(n));	
	end
	
